<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function datas()
    {
        return $this->hasMany('Data');
    }

    public function regions()
    {
        return $this->hasMany('Region');
    }

    public function sites()
    {
        return $this->hasMany('Site');
    }

}